<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
// Establecer la zona horaria a Perú
date_default_timezone_set('America/Lima');
header('Content-Type: application/json');

// Configuración de conexión IMAP
$hostname = '{mail.elgamermexicano.com:993/imap/ssl}INBOX';
$username = 'mail@elgamermexicano.com';
$password = '$][}rH+?MuAk';

function convert_to_utf8($data) {
    if (is_array($data)) {
        return array_map('convert_to_utf8', $data);
    } elseif (is_string($data)) {
        return mb_convert_encoding($data, 'UTF-8', 'UTF-8');
    }
    return $data;
     
}

// Verificamos que se haya pasado el parámetro GET "email"
if (!isset($_GET['email']) || empty($_GET['email'])) {
    echo json_encode([
        'tipo' => 'ninguno', 
        'contenido' => 'No se ha especificado un email.',
        'hora' => date("Y-m-d H:i:s")
    ]);
    exit;
}

$email = urldecode($_GET['email']);
$email = str_replace(' ', '+', $email);

// Verificamos que se haya pasado el parámetro GET "telefono" (o number)

//$telefono = $_GET['telefono'];





// Conectar al servidor IMAP
$inbox = imap_open($hostname, $username, $password) or die(json_encode([
    'tipo' => 'ninguno', 
    'contenido' => 'Error de conexión IMAP',
    'hora' => date("Y-m-d H:i:s")
]));

// Buscar correos desde hoy (SINCE filtra solo por fecha)
$search_criteria = 'SINCE "' . date('d-M-Y', strtotime('-159999 minutes')) . '"';
$emails = imap_search($inbox, $search_criteria);

$result = null;

// Filtrar manualmente los correos para quedarnos solo con los últimos 15 minutos
// y que sean enviados a la dirección especificada en GET
$filtered_emails = [];
if ($emails) {
    foreach ($emails as $email_number) {
        $header = imap_headerinfo($inbox, $email_number);
        $email_date = strtotime($header->date);
        if ($email_date >= strtotime('-15 minutes')) { // Filtrar por 15 minutos
            // Filtrar por dirección en "To"
            $match = false;
            if (isset($header->to)) {
                foreach ($header->to as $to) {
                    if (isset($to->mailbox) && isset($to->host)) {
                        $fullEmail = strtolower($to->mailbox . '@' . $to->host);
                        if ($fullEmail == strtolower($email)) {
                            $match = true;
                            break;
                        }
                    }
                }
            }
            if ($match) {
                $filtered_emails[] = $email_number;
            }
        }
    }
}

if ($filtered_emails) {
    rsort($filtered_emails); // Ordenar del más reciente al más antiguo
}

// Expresiones regulares para enlaces y código de 6 dígitos
$patternLink1 = '/https?:\/\/[^\]\s"]*travel[^\]\s"]*/i';
$patternLink2 = '/https?:\/\/[^\]\s"]*update-primary-location[^\]\s"]*/i';
$patternCode  = '/ (?<!\S)(\d{6})(?!\S) /';

if (!empty($filtered_emails)) {
    foreach ($filtered_emails as $email_number) {
        // Obtener nuevamente el header para usar el subject
        $header = imap_headerinfo($inbox, $email_number);
        $subject = isset($header->subject) ? $header->subject : '';
        
        $structure = imap_fetchstructure($inbox, $email_number);
        $message = '';

        if (isset($structure->parts) && count($structure->parts)) {
            for ($i = 0; $i < count($structure->parts); $i++) {
                $part = $structure->parts[$i];
                if ($part->subtype == 'PLAIN' || $part->subtype == 'HTML') {
                    $message .= imap_fetchbody($inbox, $email_number, $i + 1);
                }
            }
        } else {
            $message = imap_body($inbox, $email_number);
        }
        
        // Unir el contenido en una sola línea
        $message = preg_replace('/=\r?\n/', '', $message);
        $message = str_replace(array("\r", "\n"), '', $message);
        $message = quoted_printable_decode($message);

        // Primero, buscamos el código de 6 dígitos (prioridad) y comprobamos que el subject contenga "Disney"
        if (preg_match($patternCode, $message, $matches)) {
            if (stripos($subject, 'Disney') !== false) {
                //echo $message;
                $codigo = trim($matches[1]);
                $result = ['tipo' => 'codigo', 'codigo' => $codigo];
                break;
            }
        }

        // Si no se encontró el código, buscamos enlaces que contengan "Netflix" en el subject
        if (preg_match($patternLink1, $message, $matches)) {
            if (stripos($subject, 'Netflix') !== false) {
                $result = ['tipo' => 'link', 'link' => trim($matches[0])];
                break;
            }
        }
        if (preg_match($patternLink2, $message, $matches)) {
            if (stripos($subject, 'Netflix') !== false) {
                $result = ['tipo' => 'link', 'link' => trim($matches[0])];
                break;
            }
        }
    }
}

// Cerrar conexión IMAP
imap_close($inbox);

// Función para realizar consulta cURL
function curlConsultar($email, $option) {
    $url = "https://codigos.sonplaymak.com/consultar";
    $postData = http_build_query([
        'email' => $email,
        'option' => $option
    ]);
    
    $headers = [
        "Content-Type: application/x-www-form-urlencoded",
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36"
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
    
}

// Si no se encontró resultado en IMAP, intentar con las consultas cURL
if ($result == null) {
    // Primero con option "code"
   // var_dump($email);
    $curlResponse = curlConsultar($email, "code");
    //var_dump($curlResponse);
    if ($curlResponse) {
        // Procesar el HTML recibido
        $curlResponse = preg_replace('/=\r?\n/', '', $curlResponse);
        $curlResponse = str_replace(array("\r", "\n"), '', $curlResponse);
        $curlResponse = quoted_printable_decode($curlResponse);
        $pattern = '/<a\s+href=["\'](https:\/\/www\.netflix\.com\/account\/travel\/verify\?nftoken=[^"\']+)["\']/i';

        if (preg_match($pattern, $curlResponse, $matches)) {
            $result = ['tipo' => 'link', 'link' => trim($matches[1])];
           // $result['link'] =  html_entity_decode(urldecode($matches[1]));
        } elseif (preg_match($patternLink2, $curlResponse, $matches)) {
            $result = ['tipo' => 'link', 'link' => trim($matches[0])];
          //  $result['link'] =  html_entity_decode(urldecode($matches[0]));
        } elseif (preg_match($patternCode, $curlResponse, $matches)) {
            //$result = ['tipo' => 'codigo', 'codigo' => trim($matches[1])];
        }
        $result = convert_to_utf8($result);
        if(isset($result['link'])) $result['link'] =  html_entity_decode(urldecode($result['link']));
        

    }
    
    // Si aún no se encontró, intentar con option "hogar"
    if ($result === null) {
        $curlResponse = curlConsultar($email, "hogar");
        if ($curlResponse) {
            $curlResponse = preg_replace('/=\r?\n/', '', $curlResponse);
            $curlResponse = str_replace(array("\r", "\n"), '', $curlResponse);
            $curlResponse = quoted_printable_decode($curlResponse);
            //var_dump($curlResponse);
            if (preg_match($patternLink1, $curlResponse, $matches)) {
                $result = ['tipo' => 'link', 'link' => trim($matches[0])];
               // $result['link'] =  html_entity_decode(urldecode($matches[0]));
            } elseif (preg_match($patternLink2, $curlResponse, $matches)) {
                $result = ['tipo' => 'link', 'link' => trim($matches[0])];
               // $result['link'] =  html_entity_decode(urldecode($matches[1]));
            } elseif (preg_match($patternCode, $curlResponse, $matches)) {
                //$result = ['tipo' => 'codigo', 'codigo' => trim($matches[1])];
            }
            $result = convert_to_utf8($result);
             if(isset($result['link'])) $result['link'] =  html_entity_decode(urldecode($result['link']));
            //echo json_encode($result);
            //var_dump($result);
        }
    }
}





//echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

// Responder en formato JSON
if ($result !== null) {
    $result['hora'] = date("Y-m-d H:i:s");
    echo json_encode($result);
} else {
    echo json_encode([
        'tipo' => 'ninguno', 
        'contenido' => 'no',
        'hora' => date("Y-m-d H:i:s")
    ]);
}
?>
